







//Nappainten ja hiiren nappien tilat
const unsigned char Vapaa = 0,
                    Painettu = 1,
                    Pohjassa = 2,
                    Nostettu = 3;

const unsigned short HIIRENNAPPIENLKM = 10;

const unsigned short NAPPAINTENLKM = 133;




struct HIIRENNAPPITIEDOT
{
    unsigned short Tila;
    unsigned char SDL_NapinID;
};


class HIIRI
{
    private:
        float X, Y, Z;
        float Xd,Yd,Zd;
        HIIRENNAPPITIEDOT *NappiTiedot;   //dynaaminen taulukko
        unsigned short NappienLKM;
        unsigned short RuudunLeveys;
        unsigned short RuudunKorkeus;

    public:
        void Alusta( unsigned short Leveys, unsigned short Korkeus );
        void Paivita( SDL_Event &Tapahtuma );
        unsigned char NapinTila( unsigned char Nappi);
        float AnnaX();
        float AnnaY();
        float AnnaXd();
        float AnnaYd();
        bool OnkoSisalla( double TarkasteltavaX, double TarkasteltavaY, double TarkasteltavaLeveys, double TarkasteltavaKorkeus );
};

#define BUT_LEFT    0x00
#define BUT_MIDDLE  0x01
#define BUT_RIGHT   0x02




struct NAPPAINTIEDOT
{
    unsigned char Tila;
    SDLKey sym;
};

class NAPPAIMET
{
    private:
        NAPPAINTIEDOT *NappainTiedot;   //dynaaminen taulukko
        unsigned short NappaintenLKM;

    public:        
        void Alusta();
        void Paivita( SDL_Event &Tapahtuma );
        unsigned char NapinTila( unsigned char Nappain);    
};








#define NAP_BACKSPACE   0x00          // '\b'    backspace
#define NAP_TAB         0x01          // '\t'    tab
#define NAP_CLEAR       0x02          //         clear
#define NAP_RETURN      0x03          // '\r'    return
#define NAP_PAUSE       0x04          //         pause
#define NAP_ESCAPE      0x05          // '^['    escape
#define NAP_SPACE       0x06          // ' '     space 
#define NAP_EXCLAIM     0x07          // '!'     exclaim 
#define NAP_QUOTEDBL    0x08          // '"'     quotedbl 
#define NAP_HASH        0x09          // '#'     hash 
#define NAP_DOLLAR      0x0A          // '$'     dollar 
#define NAP_AMPERSAND   0x0B          // '&'     ampersand 
#define NAP_QUOTE       0x0C          // '''     quote 
#define NAP_LEFTPAREN   0x0D          // '('     left parenthesis 
#define NAP_RIGHTPAREN  0x0E          // ')'     right parenthesis 
#define NAP_ASTERISK    0x0F          // '*'     asterisk 
#define NAP_PLUS        0x10          // '+'     plus sign 
#define NAP_COMMA       0x11          // ','     comma 
#define NAP_MINUS       0x12          // '-'     minus sign 
#define NAP_PERIOD      0x13          // '.'     period 
#define NAP_SLASH       0x14          // '/'     forward slash 
#define NAP_0           0x15          // '0'     0 
#define NAP_1           0x16          // '1'     1 
#define NAP_2           0x17          // '2'     2 
#define NAP_3           0x18          // '3'     3 
#define NAP_4           0x19          // '4'     4 
#define NAP_5           0x1A          // '5'     5 
#define NAP_6           0x1B          // '6'     6 
#define NAP_7           0x1C          // '7'     7 
#define NAP_8           0x1D          // '8'     8 
#define NAP_9           0x1E          // '9'     9 
#define NAP_COLON       0x1F          // ':'     colon 
#define NAP_SEMICOLON   0x20          // ';'     semicolon 
#define NAP_LESS        0x21          // '<'     less-than sign 
#define NAP_EQUALS      0x22          //  '='     equals sign 
#define NAP_GREATER     0x23          // '>'     greater-than sign 
#define NAP_QUESTION    0x24          // '?'     question mark 
#define NAP_AT          0x25          // '@'     at 
#define NAP_LEFTBRACKET 0x26          // '['     left bracket 
#define NAP_BACKSLASH   0x27          // '\'     backslash 
#define NAP_RIGHTBRACKET  0x28        // ']'   right bracket 
#define NAP_CARET       0x29          // '^'     caret 
#define NAP_UNDERSCORE  0x2A          // '_'     underscore 
#define NAP_BACKQUOTE   0x2B          // '`'     grave 
#define NAP_A           0x2C          // 'a'     a 
#define NAP_B           0x2D          // 'b'     b 
#define NAP_C           0x2E          // 'c'     c 
#define NAP_D           0x2F          // 'd'     d 
#define NAP_E           0x30          // 'e'     e 
#define NAP_F           0x31          // 'f'     f 
#define NAP_G           0x32          // 'g'     g 
#define NAP_H           0x33          // 'h'     h 
#define NAP_I           0x34          // 'i'     i 
#define NAP_J           0x35          // 'j'     j 
#define NAP_K           0x36          // 'k'     k 
#define NAP_L           0x37          // 'l'     l 
#define NAP_M           0x38          // 'm'     m 
#define NAP_N           0x39          // 'n'     n 
#define NAP_O           0x3A          // 'o'     o 
#define NAP_P           0x3B          // 'p'     p 
#define NAP_Q           0x3C          // 'q'     q 
#define NAP_R           0x3D          // 'r'     r 
#define NAP_S           0x3E          // 's'     s 
#define NAP_T           0x3F          // 't'     t 
#define NAP_U           0x40          // 'u'     u 
#define NAP_V           0x41          // 'v'     v 
#define NAP_W           0x42          // 'w'     w 
#define NAP_X           0x43          // 'x'     x 
#define NAP_Y           0x44          // 'y'     y 
#define NAP_Z           0x45          // 'z'     z 
#define NAP_DELETE      0x46          // '^?'    delete 
#define NAP_KP0         0x47          //         keypad 0 
#define NAP_KP1         0x48          //         keypad 1 
#define NAP_KP2         0x49          //         keypad 2 
#define NAP_KP3         0x4A          //         keypad 3 
#define NAP_KP4         0x4B          //         keypad 4 
#define NAP_KP5         0x4C          //         keypad 5 
#define NAP_KP6         0x4D          //         keypad 6 
#define NAP_KP7         0x4E          //         keypad 7 
#define NAP_KP8         0x4F          //         keypad 8 
#define NAP_KP9         0x50          //         keypad 9 
#define NAP_KP_PERIOD   0x51          // '.'     keypad period 
#define NAP_KP_DIVIDE   0x52          // '/'     keypad divide 
#define NAP_KP_MULTIPLY 0x53          // '*'     keypad multiply 
#define NAP_KP_MINUS    0x54          // '-'     keypad minus 
#define NAP_KP_PLUS     0x55          // '+'     keypad plus 
#define NAP_KP_ENTER    0x56          // '\r'    keypad enter 
#define NAP_KP_EQUALS   0x57          // '='     keypad equals 
#define NAP_UP          0x58          //         up arrow 
#define NAP_DOWN        0x59          //         down arrow 
#define NAP_RIGHT       0x5A          //         right arrow 
#define NAP_LEFT        0x5B          //         left arrow 
#define NAP_INSERT      0x5C          //         insert 
#define NAP_HOME        0x5D          //         home 
#define NAP_END         0x5E          //         end 
#define NAP_PAGEUP      0x5F          //         page up 
#define NAP_PAGEDOWN    0x60          //         page down 
#define NAP_F1          0x61          //         F1 
#define NAP_F2          0x62          //         F2 
#define NAP_F3          0x63          //         F3 
#define NAP_F4          0x64          //         F4 
#define NAP_F5          0x65          //         F5 
#define NAP_F6          0x66          //         F6 
#define NAP_F7          0x67          //         F7 
#define NAP_F8          0x68          //         F8 
#define NAP_F9          0x69          //         F9 
#define NAP_F10         0x6A          //         F10 
#define NAP_F11         0x6B          //         F11 
#define NAP_F12         0x6C          //         F12 
#define NAP_F13         0x6D          //         F13 
#define NAP_F14         0x6E          //         F14 
#define NAP_F15         0x6F          //         F15 
#define NAP_NUMLOCK     0x70          //         numlock 
#define NAP_CAPSLOCK    0x71          //         capslock 
#define NAP_SCROLLOCK   0x72          //         scrollock 
#define NAP_RSHIFT      0x73          //         right shift 
#define NAP_LSHIFT      0x74          //         left shift 
#define NAP_RCTRL       0x75          //         right ctrl 
#define NAP_LCTRL       0x76          //         left ctrl 
#define NAP_RALT        0x77          //         right alt 
#define NAP_LALT        0x78          //         left alt 
#define NAP_RMETA       0x78          //         right meta 
#define NAP_LMETA       0x7A          //         left meta 
#define NAP_LSUPER      0x7B          //         left windows key 
#define NAP_RSUPER      0x7C          //         right windows key 
#define NAP_MODE        0x7D          //         mode shift 
#define NAP_HELP        0x7E          //         help 
#define NAP_PRINT       0x7F          //         print-screen 
#define NAP_SYSREQ      0x80          //         SysRq 
#define NAP_BREAK       0x81          //         break 
#define NAP_MENU        0x82          //         menu 
#define NAP_POWER       0x83          //         power 
#define NAP_EURO        0x84          //         euro
